/*  Datawarehouse - DB-Funktionen

    Archivieren vorgegebene Spalten jeweils am ersten des Monats um 1 Uhr. Die archivierung der daten wird über das
    Standard-SQL "DailyDBFunctions.Datawarehouse" gestartet.

SELECT tlog.datawarehouse_all_set( CURRENT_DATE::DATE )
FROM information_schema.routines
WHERE
    ( date_part( 'day', CURRENT_DATE ) = 1 )
  AND routine_schema = 'tlog'
  AND routine_name = 'datawarehouse_all_set'
;

*/

-- Artikelstamm
CREATE OR REPLACE FUNCTION TLog.DataWarehouse_art_set(
        IN _snapshot_date DATE
    )
        RETURNS void
    AS $$
    BEGIN
        -- TODO AXS vergangene Zeitpunkte zulassen
        INSERT INTO tlog.datawarehouse_art
            SELECT
                _snapshot_date
                , ak_nr
                , ak_standard_mgc
                , ak_hest
                , ak_rust
                , ak_fertk
                , ak_matk
                , ak_awkost
                , ak_los
                , ak_vkpbas
                , ak_vkpfaktor
                , ak_vkprund
                , ak_vkpbasfix
                , ak_tot
                , ak_res
                , ak_bes
                , ak_verfueg
                , ak_ks
            FROM art
            WHERE NOT ak_nr LIKE 'AW.%'
            ;
        RETURN;
    END $$ LANGUAGE plpgsql;
--

-- Verkauf
CREATE OR REPLACE FUNCTION TLog.DataWarehouse_auftg_set(
        IN _snapshot_date DATE
    )
        RETURNS void
    AS $$
    BEGIN
        -- TODO AXS vergangene Zeitpunkte zulassen
        INSERT INTO tlog.datawarehouse_auftg
            SELECT
                _snapshot_date
                , p_id
                , p_code
                , p_nummer
                , p_pos
                , p_aknr
                , p_menge_gme
                , p_mengeb_gme
                , p_mengel_gme
                , p_mengef_gme
                , p_ks
                , p_preis_me
                , p_preis_gwaer
                , p_waer
                , p_kurs
                , p_scode
                , p_sproz
                , p_rabatt
                , p_CanRabatt
                , p_wert_ep_netto
                , p_wert_netto
                , p_wert_netto_gwaer
                , p_IsUmsatz
                , p_datum_eingang
                , p_datum_erfasst
                , p_datum_soll
                , p_datum_ist
                , p_done
                , p_storniert
                , p_datum_storniert
                , p_adkrz
                , p_adkrzl
                , p_adkrzf
            FROM TWawi.Auftg_Pos

           WHERE -- Aktuell: nur Externe Angebote/Aufträge. Keine Materialliste
                 p_code IN ('E' , 'A')
             AND (   -- nur Aufträge, welche nicht bereits mit erledigt im Vorzeitraum existierten. Es werden also nur Veränderungen an laufenden Aufträgen geloggt und oder der Auftrag einmalig, wenn dieser geschlossen ist.
                     NOT p_done
                     -- auftrag bereits mit erledigt im vorzeitraum vorhanden
                  OR NOT EXISTS(SELECT true FROM tlog.datawarehouse_auftg da WHERE da.p_id = Auftg_Pos.p_id AND da.p_done AND da.snapshot_date < _snapshot_date)            
                  )
           ; 
        RETURN;
    END $$ LANGUAGE plpgsql;
--

-- Lager
CREATE OR REPLACE FUNCTION TLog.DataWarehouse_lag_set(
        IN _snapshot_date DATE
    )
        RETURNS void
    AS $$
    BEGIN
        -- TODO AXS vergangene Zeitpunkte zulassen
        INSERT INTO tlog.datawarehouse_lag
            SELECT
                _snapshot_date
                , lg_id
                , lg_aknr
                , lg_ort
                , lg_anztot
                , lg_chnr
                , lg_sperr
                , lgo_verfgbar
                , lgo_werthg
                , lgo_beistell
              FROM lag
              LEFT JOIN lagerorte ON lgo_name = lg_ort;
                   -- lagerorte__get_setup(lg_ort)
        RETURN;
    END $$ LANGUAGE plpgsql;
--

-- Überfunktion
CREATE OR REPLACE FUNCTION TLog.DataWarehouse_all_set(
        IN _snapshot_date DATE
    )
        RETURNS void
    AS $$
    BEGIN
        PERFORM tlog.datawarehouse_art_set( _snapshot_date );
        PERFORM tlog.datawarehouse_auftg_set( _snapshot_date );
        PERFORM tlog.datawarehouse_lag_set( _snapshot_date );
        RETURN;
    END $$ LANGUAGE plpgsql;
--